// -----------------
// https://sandcastle.cesium.com/?src=Lighting.html

const scratchIcrfToFixed = new Cesium.Matrix3();
const scratchMoonPosition = new Cesium.Cartesian3();
const scratchMoonDirection = new Cesium.Cartesian3();

function getMoonDirection(result) {
  result = Cesium.defined(result) ? result : new Cesium.Cartesian3();
  const icrfToFixed = scratchIcrfToFixed;
  const date = viewer.clock.currentTime;
  if (
    !Cesium.defined(Cesium.Transforms.computeIcrfToFixedMatrix(date, icrfToFixed))
  ) {
    Cesium.Transforms.computeTemeToPseudoFixedMatrix(date, icrfToFixed);
  }
  const moonPosition =
    Cesium.Simon1994PlanetaryPositions.computeMoonPositionInEarthInertialFrame(
      date,
      scratchMoonPosition,
    );
  Cesium.Matrix3.multiplyByVector(icrfToFixed, moonPosition, moonPosition);
  const moonDirection = Cesium.Cartesian3.normalize(
    moonPosition,
    scratchMoonDirection,
  );
  return Cesium.Cartesian3.negate(moonDirection, result);
}


function initLighting()  {
	moonLight.direction = getMoonDirection();  // Updated every frame
}

const directionalLight = new Cesium.DirectionalLight({
  direction: new Cesium.Cartesian3(
    0.2454278300540191,
    0.8842635425193919,
    0.39729481195458805,
  ),
  intensity: 2.0,
});

const moonLight = new Cesium.DirectionalLight({
  direction: scratchMoonPosition, // will change to getMoonDirection(), Updated every frame
  color: new Cesium.Color(0.9, 0.925, 1.0),
  intensity: 0.5,
});

const sunLight = new Cesium.SunLight();

/*
const flashlight = new Cesium.DirectionalLight({
  direction: scene.camera.directionWC, // Updated every frame
  intensity: 3.0,
});
*/


/*
function setTime(iso8601) {
  const currentTime = Cesium.JulianDate.fromIso8601(iso8601);
  const endTime = Cesium.JulianDate.addDays(
    currentTime,
    2,
    new Cesium.JulianDate(),
  );

  viewer.clock.currentTime = currentTime;
  viewer.timeline.zoomTo(currentTime, endTime);
}
*/

function lighting_reset() {
  // Set scene defaults
  scene.globe.enableLighting = true;
  scene.light = sunLight;
  scene.globe.dynamicAtmosphereLighting = true;
  scene.globe.dynamicAtmosphereLightingFromSun = false;
  scene.atmosphere.dynamicLighting = Cesium.DynamicAtmosphereLightingType.NONE;
  // setTime("2020-01-09T23:00:39.018261982600961346Z");
  viewer.scene.skyAtmosphere.show = true;
}

function lighting_none()  {
	lighting_reset();
	scene.globe.enableLighting = false;
}

function lighting_clock()  {
	lighting_reset();
	scene.atmosphere.dynamicLighting = Cesium.DynamicAtmosphereLightingType.SUNLIGHT;
}

function lighting_night()  {
	// /*
	lighting_reset();
	scene.light = moonLight;
	scene.globe.dynamicAtmosphereLightingFromSun = true;
	scene.atmosphere.dynamicLighting = Cesium.DynamicAtmosphereLightingType.SCENE_LIGHT;
	// */
	
    // Toggle the sky atmosphere visibility
    viewer.scene.skyAtmosphere.show = false;	
}

function changeLightingIntensity(el)  {
	moonLight.intensity = el.value;
}

function changeLightingType(el)  {	
	if (el.value == 'clock')  {  
		lighting_clock();
		// disable light intensity
		txtIntensity.disabled = true;
	} else if (el.value == 'night')  {
		lighting_night();
		// enable light intensity
		txtIntensity.disabled = false;
	} else  {
		lighting_none();  
		// disable light intensity
		txtIntensity.disabled = true;		
	}
}
