    // Your access token can be found at: https://ion.cesium.com/tokens.
    // Replace `your_access_token` with your Cesium ion access token.

	// Cesium Ion key:
	try {
		Cesium.Ion.defaultAccessToken = ionKey;
	}  catch (err)  {
		alert("Missing Cesium Ion Key.  Things will not work for you.  See documentaton on GitHub for help.");
		console.log(err);
	}
	
	// User Bing maps key, to prevent using Cesium default key, fixes Bing maps problem
	/*
	try {
		Cesium.BingMapsImageryProvider.defaultKey = bingKey;
	}  catch (err)  {
		alert("Missing Bing Maps Key.  Things might not work for you.  See documentaton on GitHub for help.");
		console.log(err);
	}
	*/
	
	cesiumTerrainProvider = await Cesium.createWorldTerrainAsync();
	
	getImageryProviders();	
	
	// Override date functions to give local time
	// This must be done BEFORE initializing `viewer`.
	Cesium.Timeline.prototype.makeLabel = function (time) {
	  const localDate = Cesium.JulianDate.toDate(time);
	  return localDate.toLocaleString();
	};
	
    // Initialize the Cesium Viewer in the HTML element with the `cesiumDiv` ID.
	viewer = new Cesium.Viewer('cesiumContainer', {
		infoBox : true, // false
		vrButton: true, // false
		animation : true,  // false
		timeline : true, // false
		geocoder : false,
		homeButton : false,
		infoBox : true, // ???
		sceneModePicker : false,
		navigationHelpButton : true,
		imageryProvider : myImageryProviders['arcGISAerial'], // myImageryProviders['bingAerial'],	
		fullscreenButton : false,
		// baseLayerPicker: false,
		selectionIndicator : true,  // toggle??
		navigationInstructionsInitiallyVisible : false,
		terrain: Cesium.Terrain.fromWorldTerrain({requestWaterMask: true}),   // toggle
		// globe: false,
		shadows: false,   // toggle
	});    		
		
	// Enable rendering the sky
	viewer.scene.skyAtmosphere.show = true;

	viewer.extend(Cesium.viewerDragDropMixin);
	scene = viewer.scene;
	canvas = scene.canvas;

	// FIXME -- For some reason, picking from the globe breaks if `baseLayerPicker` is set to `false`.
	// So, we'll leave it as-is, but then destroy it.
	viewer.baseLayerPicker.destroy();
	
    // Add Cesium OSM Buildings, a global 3D buildings layer.
    osmBuildingsTileset = await Cesium.createOsmBuildingsAsync();
    viewer.scene.primitives.add(osmBuildingsTileset);   
	osmBuildingsTileset.show = false;	
		
	// To use sampledProperty, we need to define the availability time interval of the entity.
	// The following is just how to define the time. We will use the current system time. 
	// Set bounds of our simulation time.
	// At first clockview object for calling system time is created:
	clockView				=	new Cesium.ClockViewModel(viewer.clock);
	start					=	clockView.systemTime;
	stop 					= 	Cesium.JulianDate.addSeconds(viewer.clock.currentTime, 3600, new Cesium.JulianDate());

	// Make sure viewer is at the desired time.
	viewer.clock.startTime 		= 	start.clone();
	// viewer.clock.stopTime 	= 	stop.clone();
	viewer.clock.currentTime 	= 	start.clone();
	// viewer.clock.clockRange 	= 	Cesium.ClockRange.LOOP_STOP; //Loop at the end
	viewer.clock.multiplier 	= 	1;
				

	// ========================
	// Format time for user's local time zone
	// const currentDate = new Date();
	// const timezoneOffsetMinutes = 0;  //currentDate.getTimezoneOffset();
	
	let timeFormatter = new Intl.DateTimeFormat("en-US", {
	  hour: "numeric",
	  minute: "2-digit",
	  hour12: true,
	});

	viewer.animation.viewModel.dateFormatter = function(date, viewModel) {
		// Shift current date by timezone offset
		// const localDatetime = new Date( new Date(date).getTime() - timezoneOffsetMinutes * 60000);
		// return localDatetime.toLocaleDateString();
		if (date.secondsOfDay)  {	
			return new Date(date).toLocaleDateString();
		}
	};

	viewer.animation.viewModel.timeFormatter = function(date, viewModel) {
		// Shift current date by timezone offset
		// const localDatetime = new Date( new Date(date).getTime() - timezoneOffsetMinutes * 60000);
		// return timeFormatter.format(localDatetime);
		if (date.secondsOfDay)  {	
			return timeFormatter.format(new Date(date));
		}
	};
	// ========================

	googleTileset = await Cesium.createGooglePhotorealistic3DTileset();
	viewer.scene.primitives.add(googleTileset);
	googleTileset.show = false;	  // toggle

	initCesium();
	// initLighting();
	
	export async function getAltMSL(lon, lat, func, funcArgs = {})  {
		// Query the terrain height of a Cartographic position.
		// Call `func(lat, lon, altMSL)` when done.
		// const terrainProvider = await Cesium.createWorldTerrainAsync();

		const positions = [Cesium.Cartographic.fromDegrees(lon, lat)];
		try {
			updatedPositions = await Cesium.sampleTerrain(cesiumTerrainProvider, 11, positions, true).then(function (updatedPositions) {
				// console.log(updatedPositions[0].height);
				func(lat, lon, updatedPositions[0].height, funcArgs);
			});
		} catch (error) {
			console.log('A tile request error occurred.');
		} 
	}
	// Make getAltMSL function available outside this module:
	window.getAltMSL = getAltMSL;
	
	export async function getAltMSLArray(cartoArray, func, funcArgs = {})  {
		// Query the terrain height of an ARRAY of Cartographic positions.
		// Call `func(...)` when done.
		// const terrainProvider = await Cesium.createWorldTerrainAsync();

		// const positions = [Cesium.Cartographic.fromDegrees(lon, lat)];
		const positions = cartoArray;
		try {
			updatedPositions = await Cesium.sampleTerrain(cesiumTerrainProvider, 11, positions, true).then(function (updatedPositions) {
				// console.log(updatedPositions);
				func(updatedPositions, funcArgs);
			});
		} catch (error) {
			console.log('A tile request error occurred.');
		} 
	}
	// Make getAltMSL function available outside this module:
	window.getAltMSLArray = getAltMSLArray;

	
	// Dispatch the event.
	window.dispatchEvent(cesiumViewerLoad);
	

