class missionCesiumObjects {
    constructor() {
        this.walls = {};
        this.nodes = {};
        this.polylines = {};
    };

    removeFromCesiumViewer() {
        // assuming cesium viewer variable "viewer" is defined;
        // Apparently need to define these and not use "this" to make it work
        let walls = this.walls;
        let nodes = this.nodes;
        let polylines = this.polylines;
        Object.keys(this.walls).forEach(function(key){
            viewer.entities.removeById(walls[key].id);
        });
        Object.keys(this.nodes).forEach(function(key){
            viewer.entities.removeById(nodes[key].id);
        });
        Object.keys(this.polylines).forEach(function(key){
            viewer.entities.removeById(polylines[key].id);
        });
    };

    transfer(datastore) {
        for (let key in this.walls) {
            datastore.walls[key] = this.walls[key];
        }
        for (let key in this.nodes) {
            datastore.nodes[key] = this.nodes[key];
        }
        for (let key in this.polylines) {
            datastore.polylines[key] = this.polylines[key];
        }
    }
};

class cesiumObject {
    constructor(args) {
        this.id = undefined;
        this.name = undefined;
        this.position = undefined;
        this.label = undefined;
        this.show = true;
        Object.assign(this, args);
    }
};

class Wall extends cesiumObject {
    constructor (args = {}) {
        super(args);
        this.wall = {};
        // this.billboard = {};
        Object.assign(this.wall, {
            positions: undefined,
            material: undefined,
            outline: undefined,
            minimumHeights: undefined
        }, args);
    }
};

class Point extends cesiumObject {
    constructor (args) {
        super(args);
        this.point = {};
        Object.assign(this.point, {
            color: undefined,
            outlineColor: undefined,
            outlineWidth: undefined,
            pixelSize: undefined,
            heightReference: Cesium.HeightReference.CLAMP_TO_TERRAIN
        }, args);
    }
};

class Polyline extends cesiumObject {
    constructor(args) {
        super(args);
        this.polyline = {};
        Object.assign(this.polyline, {
            positions: undefined,
            material: undefined,
            width: undefined,
            clampToGround: undefined
        }, args);
    }
};

class Ellipsoid extends cesiumObject {
    constructor(args) {
        super(args);
        this.ellipsoid = {};
        Object.assign(this.ellipsoid, {
            radii: undefined,
            material: undefined,
            outline: false,
        }, args);
    }
}

class Ellipse extends cesiumObject {
    constructor(args) {
        super(args);
        this.ellipse = {};
        Object.assign(this.ellipse, {
            semiMinorAxis: undefined,
            semiMajorAxis: undefined,
            material: undefined,
        }, args);
    }
}
