var screenRecorder;
var screenRecorderActive = false;

// Add screen shot cability (save single .jpg)
// See https://stackoverflow.com/questions/4912092/using-html5-canvas-javascript-to-take-in-browser-screenshots/60231897#60231897

function screenRecorderStart()  {
	setTimeout(() => {
		console.log("Delayed for 3 seconds.");

		_screenRecorderStart();
	}, "3000");
}

async function _screenRecorderStart() {
	/*
	var stream = await navigator.mediaDevices.getDisplayMedia({
	  video: {cursor: 'always'} // true,
	  audio: false});
	*/
	
	const displayMediaOptions = {
		video: {
			displaySurface: "browser",
		},
		audio: {
			suppressLocalAudioPlayback: false,
		},
		preferCurrentTab: true,
		// selfBrowserSurface: "exclude",
		systemAudio: "exclude",
		surfaceSwitching: "include",
		monitorTypeSurfaces: "include",
	};


	var stream = await navigator.mediaDevices.getDisplayMedia(displayMediaOptions);
	
	
	screenRecorder = new MediaRecorder(stream);

	const chunks = [];
	screenRecorder.ondataavailable = e => chunks.push(e.data);
	screenRecorder.onstop = e => {
		const blob = new Blob(chunks, { type: chunks[0].type });
		// console.log(blob);
		stream.getVideoTracks()[0].stop();

		// filename="yourCustomFileName"
		// getDateTimestamp() is in `util.js`
		filename = "screencast_" + getDateTimestamp(new Date());		
		
		if (window.navigator.msSaveOrOpenBlob)  {
			window.navigator.msSaveBlob(blob, filename);
		}
		else  {
			var elem = window.document.createElement('a');
			elem.href = window.URL.createObjectURL(blob);
			elem.download = filename;        
			document.body.appendChild(elem);
			elem.click();        
			document.body.removeChild(elem);
		}

		screenRecorderActive = false;
		btnScreenRecorder.textContent = "Start Screencast";
		btnScreenRecorder.style.backgroundColor = '';
	};
	
	screenRecorder.onstart = e => {
		screenRecorderActive = true;
		btnScreenRecorder.textContent = "Stop Screencast";
		btnScreenRecorder.style.backgroundColor = 'red';
	};
	
	screenRecorder.start();
}

function screenRecorderStop()  {
	screenRecorder.stop();
}

function screenRecorderToggle()  {
	if (screenRecorderActive)  {
		screenRecorderStop();
	}  else  {
		screenRecorderStart();
	}
}


// screenRecorderStart(); //Start of the recording
// screenRecorderStop();



// =======================================================================

// Taking a screenshot.  See https://stackoverflow.com/questions/4912092/using-html5-canvas-javascript-to-take-in-browser-screenshots/60231897#60231897
// 
// docs: https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getDisplayMedia
// see: https://www.webrtc-experiment.com/Pluginfree-Screen-Sharing/#20893521368186473
// see: https://github.com/muaz-khan/WebRTC-Experiment/blob/master/Pluginfree-Screen-Sharing/conference.js

function getDisplayMedia(options) {
    if (navigator.mediaDevices && navigator.mediaDevices.getDisplayMedia) {
        return navigator.mediaDevices.getDisplayMedia(options);
    }
    if (navigator.getDisplayMedia) {
        return navigator.getDisplayMedia(options);
    }
    if (navigator.webkitGetDisplayMedia) {
        return navigator.webkitGetDisplayMedia(options);
    }
    if (navigator.mozGetDisplayMedia) {
        return navigator.mozGetDisplayMedia(options);
    }
    throw new Error('getDisplayMedia is not defined');
}

async function takeScreenshotStream() {
    // see: https://developer.mozilla.org/en-US/docs/Web/API/Window/screen
    const width = screen.width * (window.devicePixelRatio || 1)
    const height = screen.height * (window.devicePixelRatio || 1)

    const errors = []
    let stream
    try {
        stream = await getDisplayMedia({
			preferCurrentTab: true,
			// selfBrowserSurface: "exclude",
			systemAudio: "exclude",
			surfaceSwitching: "include",
			monitorTypeSurfaces: "include",
            audio: false,
            // see: https://developer.mozilla.org/en-US/docs/Web/API/MediaStreamConstraints/video
            video: {
                width,
                height,
                frameRate: 1,
            },
        })
    } catch (ex) {
        errors.push(ex)
    }

    if (errors.length) {
        console.debug(...errors)
        if (!stream) {
            throw errors[errors.length - 1]
        }
    }

    return stream
}

async function takeScreenshotCanvas() {
    const stream = await takeScreenshotStream();

    // from: https://stackoverflow.com/a/57665309/5221762
    const video = document.createElement('video');
    const result = await new Promise((resolve, reject) => {
        video.onloadedmetadata = () => {
            video.play();
            video.pause();

            // from: https://github.com/kasprownik/electron-screencapture/blob/master/index.js
            const screenshotCanvas = document.createElement('canvas');
            screenshotCanvas.width = video.videoWidth;
            screenshotCanvas.height = video.videoHeight;
            const context = screenshotCanvas.getContext('2d');
            // see: https://developer.mozilla.org/en-US/docs/Web/API/HTMLVideoElement
            context.drawImage(video, 0, 0, video.videoWidth, video.videoHeight);
            resolve(screenshotCanvas);
        }
        video.srcObject = stream;
    })

    stream.getTracks().forEach(function (track) {
        track.stop();
    })
    
    if (result == null) {
        throw new Error('Cannot take canvas screenshot');
    }

    return result;
}

// from: https://stackoverflow.com/a/46182044/5221762
function getJpegBlob(canvas) {
    return new Promise((resolve, reject) => {
        // docs: https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/toBlob
        canvas.toBlob(blob => resolve(blob), 'image/jpeg', 0.95);
    })
}

async function takeScreenshotJpegBlob() {
    const canvas = await takeScreenshotCanvas();
    return getJpegBlob(canvas);
}


function screenShot()  {
	setTimeout(() => {
		console.log("Delayed for 3 seconds.");

		_screenShot();
	}, "3000");
}


async function _screenShot()  {
	// take the screenshot
	var screenshotJpegBlob = await takeScreenshotJpegBlob();
	
	// filename="yourCustomFileName"
	// getDateTimestamp() is in `util.js`
	filename = "screenshot_" + getDateTimestamp(new Date());		

	if (window.navigator.msSaveOrOpenBlob)  {
		window.navigator.msSaveBlob(screenshotJpegBlob, filename);
	}  else  {
		var elem = window.document.createElement('a');
		elem.href = window.URL.createObjectURL(screenshotJpegBlob);
		elem.download = filename;        
		document.body.appendChild(elem);
		elem.click();        
		document.body.removeChild(elem);
	}
}
